*
/***********************************************************************************************
This do file uses microdata to create adjusted and unadjusted time trend graphs;
***********************************************************************************************/

# delimit;
capture log close;
capture program drop all;
clear;
clear matrix;
set more off;
set mem 500M;
estimates clear;
version 10;

global data "C:/Users/nschwart/Desktop/nclb_final/sass_folder/raw_data";
global figures "C:/Users/nschwart/Desktop/nclb_final/sass_folder/figures";

global files "assign_elmid";

foreach f of global files {;

global t_outcomes "departmentalized academic_time math_ELA_ratio_alt math_ratio_alt z_sch_disc z_stu_cult avg_class salary ma_dummy";
global p_outcomes "skills_or_excellence";

/*Create graph of national trends*/

use "$data/t_`f'.dta", clear;
 rename grade_combo_other omitted_combo;
 rename s_grade_combo_other s_omitted_combo;
foreach y in 1993 1999 2003 2007 {;
 gen yr`y'= survey_year==`y';
};

foreach o of global t_outcomes {;

gen trend_`o'=.;
 reg `o' yr1999 yr2003 yr2007 
   [pw=TFNLWGT];
 predict base_`o' if survey_year==1993;
 sum base_`o' if survey_year==1993 [w=TFNLWGT];
 local mean_`o' = r(mean);
 replace trend_`o' = `mean_`o'' if survey_year==1993;
 foreach y in 1999 2003 2007 {;
  replace trend_`o' = `mean_`o'' + _b[yr`y'] if survey_year==`y';
 };
 
preserve;
collapse (firstnm) trend_`o', by(survey_year);

replace survey_year=1994 if survey_year==1993;
replace survey_year=2000 if survey_year==1999;
replace survey_year=2004 if survey_year==2003;
replace survey_year=2008 if survey_year==2007;

if "`o'"=="departmentalized" | "`o'"=="math_ELA_ratio_alt" | "`o'"=="math_ratio_alt" local a="Fraction";
if "`o'"=="academic_time" local a="Hours per week";
if "`o'"=="z_sch_disc" | "`o'"=="z_stu_cult" local a="Standardized composite score";
if "`o'"=="avg_class" local a="Students";

 scatter trend_`o' survey_year, connect(l) lpattern(solid) lcolor(black) msymbol(circle) mcolor(black) 
   xtitle("Year")
   xlabel(1994(2)2010)
      xline(2002.5, lcolor(black) lpattern(solid))
	  ytitle("`a'")
   legend(off); 
   graph export "$figures/Natl_`f'_`o'.eps", replace;

  restore;
  
drop *_`o';

};




use "$data/p_`f'.dta", clear;
 rename s_grade_combo_other s_omitted_combo;
 foreach y in 1993 1999 2003 2007 {;
gen yr`y'= survey_year==`y';
};

foreach o of global p_outcomes {;

gen trend_`o'=.;
 reg `o' yr1999 yr2003 yr2007 
   [pw=AFNLWGT];
 predict base_`o' if survey_year==1993;
 sum base_`o' if survey_year==1993 [w=AFNLWGT];
 local mean_`o' = r(mean);
 replace trend_`o' = `mean_`o'' if survey_year==1993;
 foreach y in 1999 2003 2007 {;
  replace trend_`o' = `mean_`o'' + _b[yr`y'] if survey_year==`y';
 };

preserve;

collapse (firstnm) trend_`o', by(survey_year);
replace survey_year=1994 if survey_year==1993;
replace survey_year=2000 if survey_year==1999;
replace survey_year=2004 if survey_year==2003;
replace survey_year=2008 if survey_year==2007;

 scatter trend_`o' survey_year, connect(l) lpattern(solid) lcolor(black) msymbol(circle) mcolor(black) 
   xtitle("Year")
      xline(2002.5, lcolor(black) lpattern(solid))
   xlabel(1994(2)2010)
   ytitle("Fraction")
   legend(off);
   graph export "$figures/Natl_`f'_`o'.eps", replace;

  restore;
  
drop *_`o';

};




/*Run regressions and create graphs showing trend by timing of accountability*/

use "$data/t_`f'.dta", clear;
 rename grade_combo_other omitted_combo;
 rename s_grade_combo_other s_omitted_combo;
 foreach y in 1993 1999 2003 2007 {;
gen yr`y'= survey_year==`y';
};

foreach o of global t_outcomes {;

gen c_`o' = .;
gen t_`o' = .;

 reg `o' yr1999 yr2003 yr2007  
  if TREAT==0 & exca9901==0 
   [pw=TFNLWGT];
 predict c_b_`o' if survey_year==1993 & TREAT==0 & exca9901==0;
 sum c_b_`o' if survey_year==1993 & TREAT==0 & exca9901==0 [w=TFNLWGT];
 local cm`o' = r(mean);
 replace c_`o' = `cm`o'' if survey_year==1993 & TREAT==0 & exca9901==0;
 foreach y in 1999 2003 2007 {;
  replace c_`o' = `cm`o'' + _b[yr`y'] if survey_year==`y' & TREAT==0 & exca9901==0;
 };
  
 reg `o' yr1999 yr2003 yr2007 
  if TREAT==1 & exca9901==0 
   [pw=TFNLWGT];
 predict t_b_`o' if survey_year==1993 & TREAT==1 & exca9901==0;
 sum t_b_`o' if survey_year==1993 & TREAT==1 & exca9901==0 [w=TFNLWGT];
 local tm_`o' = r(mean);
 replace t_`o' = `tm_`o'' if survey_year==1993 & TREAT==1 & exca9901==0;
 foreach y in 1999 2003 2007 {;
  replace t_`o' = `tm_`o'' + _b[yr`y'] if survey_year==`y' & TREAT==1 & exca9901==0;
 };  
  
preserve;
drop if exca9901==1;
 collapse (firstnm) c_`o' t_`o', by(survey_year);
replace survey_year=1994 if survey_year==1993;
replace survey_year=2000 if survey_year==1999;
replace survey_year=2004 if survey_year==2003;
replace survey_year=2008 if survey_year==2007;
gen tmpy = .;

if "`o'"=="departmentalized" | "`o'"=="math_ELA_ratio_alt" | "`o'"=="math_ratio_alt" local a="Fraction";
if "`o'"=="academic_time" local a="Hours per week";
if "`o'"=="z_sch_disc" | "`o'"=="z_stu_cult" local a="Standardized composite score";
if "`o'"=="avg_class" local a="Students";

scatter c_`o' survey_year, msymbol(Oh) mcolor(black) ||
 scatter t_`o' survey_year, msymbol(triangle) mcolor(black) ||
 lfit c_`o' survey_year if survey_year<2003, lcolor(black) lpattern(dash) ||
 lfit c_`o' survey_year if survey_year>=2003, lcolor(black) lpattern(dash) ||
 lfit t_`o' survey_year if survey_year<2003, lcolor(black) lpattern(solid) ||
 lfit t_`o' survey_year if survey_year>=2003, lcolor(black) lpattern(solid) ||
 scatter tmpy survey_year, msymbol(Oh) connect(direct) lpattern(dash) lcolor(black) mcolor(black) ||
 scatter tmpy survey_year, msymbol(triangle) connect(direct) lpattern(solid) lcolor(black) mcolor(black) ||,
   xline(2002.5, lcolor(black) lpattern(solid))
   xtitle("Year")
   ytitle("`a'")
   xlabel(1994(2)2010)
   legend(rows(2) order(7 8) label(7 "State adopted school acct. policy by 1998") 
     label(8 "State never adopted school acct. policy before NCLB"));
   graph export "$figures/Treat_`f'_`o'.eps", replace;
   
  restore;
 
 drop *_`o';
 
 };


 
use "$data/p_`f'.dta", clear;
 rename s_grade_combo_other s_omitted_combo;
 foreach y in 1993 1999 2003 2007 {;
gen yr`y'= survey_year==`y';
};

foreach o of global p_outcomes {;

gen c_`o' = .;
gen t_`o' = .;

 reg `o' yr1999 yr2003 yr2007  
  if TREAT==0 & exca9901==0 
  [pw=AFNLWGT];
 predict c_b_`o' if survey_year==1993 & TREAT==0 & exca9901==0;
 sum c_b_`o' if survey_year==1993 & TREAT==0 & exca9901==0 [w=AFNLWGT];
 local cm`o' = r(mean);
 replace c_`o' = `cm`o'' if survey_year==1993 & TREAT==0 & exca9901==0;
 foreach y in 1999 2003 2007 {;
  replace c_`o' = `cm`o'' + _b[yr`y'] if survey_year==`y' & TREAT==0 & exca9901==0;
 };
  
 reg `o' yr1999 yr2003 yr2007 
  if TREAT==1 & exca9901==0 
  [pw=AFNLWGT];
 predict t_b_`o' if survey_year==1993 & TREAT==1 & exca9901==0;
 sum t_b_`o' if survey_year==1993 & TREAT==1 & exca9901==0 [w=AFNLWGT];
 local tm_`o' = r(mean);
 replace t_`o' = `tm_`o'' if survey_year==1993 & TREAT==1 & exca9901==0;
 foreach y in 1999 2003 2007 {;
  replace t_`o' = `tm_`o'' + _b[yr`y'] if survey_year==`y' & TREAT==1 & exca9901==0;
 };  
  
preserve;
drop if exca9901==1;
 collapse (firstnm) c_`o' t_`o', by(survey_year);
replace survey_year=1994 if survey_year==1993;
replace survey_year=2000 if survey_year==1999;
replace survey_year=2004 if survey_year==2003;
replace survey_year=2008 if survey_year==2007;
gen tmpy = .;

scatter c_`o' survey_year, msymbol(Oh) mcolor(black) ||
 scatter t_`o' survey_year, msymbol(triangle) mcolor(black) ||
 lfit c_`o' survey_year if survey_year<2003, lcolor(black) lpattern(dash) ||
 lfit c_`o' survey_year if survey_year>=2003, lcolor(black) lpattern(dash) ||
 lfit t_`o' survey_year if survey_year<2003, lcolor(black) lpattern(solid) ||
 lfit t_`o' survey_year if survey_year>=2003, lcolor(black) lpattern(solid) ||
 scatter tmpy survey_year, msymbol(Oh) connect(direct) lpattern(dash) lcolor(black) mcolor(black) ||
 scatter tmpy survey_year, msymbol(triangle) connect(direct) lpattern(solid) lcolor(black) mcolor(black) ||,
   xline(2002.5, lcolor(black) lpattern(solid))
   xtitle("Year")
   ytitle("Fraction")
   xlabel(1994(2)2010)
   legend(rows(2) order(7 8) label(7 "State adopted school acct. policy by 1998") 
     label(8 "State never adopted school acct. policy before NCLB"));
   graph export "$figures/Treat_`f'_`o'.eps", replace;

   restore;
 
 drop *_`o';
 
 };




};

